//
//  CRGradientEditor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/10/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Gradient point
//////////////////////////////////////////////////////////////////////
@interface CRGradientPoint : NSObject<NSCoding, NSCopying>
{
}

@property (copy)	NSColor* color;
@property (assign)	CGFloat location;

- (id)init;
- (id)initWithColor:(NSColor *)aColor location:(CGFloat)aLocation;
+ (id)pointWithColor:(NSColor *)aColor location:(CGFloat)aLocation;

@end

//////////////////////////////////////////////////////////////////////
// NSGradient editor
//////////////////////////////////////////////////////////////////////
@interface CRGradientEditor : CRControl
{
	NSGradient*		gradient;		// i/o gradient object
	NSMutableArray* points;			// working array of points
	
	CRPointAction	action;			// current action
	NSUInteger		colorTarget;	// color target
	NSShadow*		shadow;			// shadow cache
	
	BOOL			browsingForColor;	// signals whether we are browsing for color
	NSColorPanel*	colorPanel;		// separate color panel
}

@property (copy)	NSColor*	defaultColor;
@property (copy)	NSGradient* gradient;
@property (assign)  IBOutlet id	actionDelegate;
@property (readonly)BOOL		browsingForColor;

@end